/*
 * Decompiled with CFR 0.152.
 */
package inaba.file;

import inaba.file.io;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Properties;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class util {
    private static int deleteLength;

    public static int GetIntFromBytes(byte[] srcBytes, int offset, int length) {
        int ret = 0;
        boolean keta = true;
        ByteBuffer buffer = ByteBuffer.wrap(srcBytes, offset, length);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        ret = length == 2 ? buffer.getShort() : buffer.getInt();
        return ret;
    }

    public static void SetIntToBytes(byte[] dstBytes, int offset, int length, int val) {
        int i = 0;
        while (i < length) {
            dstBytes[offset + i] = (byte)val;
            val >>= 8;
            ++i;
        }
    }

    private static int HexToInt(char hex) {
        int val = hex;
        if (val >= 97) {
            val -= 32;
        }
        return val > 57 ? val - 65 + 10 : val - 48;
    }

    private static void ChangeHeader(byte[] header, String strUUID) {
        int[] nArray = new int[32];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 9;
        nArray[9] = 10;
        nArray[10] = 11;
        nArray[11] = 12;
        nArray[12] = 14;
        nArray[13] = 15;
        nArray[14] = 16;
        nArray[15] = 17;
        nArray[16] = 19;
        nArray[17] = 20;
        nArray[18] = 21;
        nArray[19] = 22;
        nArray[20] = 24;
        nArray[21] = 25;
        nArray[22] = 26;
        nArray[23] = 27;
        nArray[24] = 28;
        nArray[25] = 29;
        nArray[26] = 30;
        nArray[27] = 31;
        nArray[28] = 32;
        nArray[29] = 33;
        nArray[30] = 34;
        nArray[31] = 35;
        int[] pickup = nArray;
        byte[] strKey = new byte[16];
        int i = 0;
        while (i < strKey.length) {
            int high = util.HexToInt(strUUID.charAt(pickup[i * 2]));
            int low = util.HexToInt(strUUID.charAt(pickup[i * 2 + 1]));
            strKey[strKey.length - i - 1] = (byte)((high << 4) + low);
            ++i;
        }
        i = 0;
        int j = 0;
        while (i < header.length) {
            int n = i;
            header[n] = (byte)(header[n] ^ strKey[j]);
            if (++j >= strKey.length) {
                j = 0;
            }
            ++i;
        }
    }

    private static void ConvertODTTF(String fnSrc, String fnDst, String strGUID) {
        io src = new io();
        io dst = new io();
        try {
            src.Open(fnSrc, "r");
            dst.Open(fnDst, "w");
            byte[] buffer = new byte[32];
            int nRead = src.read(buffer, 0);
            util.ChangeHeader(buffer, strGUID);
            while (nRead > 0) {
                dst.write(buffer, nRead);
                nRead = src.read(buffer, 0);
            }
        }
        finally {
            src.Close();
            dst.Close();
        }
    }

    public static String TTF2ODTTF(String fnTTF) {
        String fnODTTF = String.valueOf(UUID.randomUUID().toString().toUpperCase()) + ".ODTTF";
        util.ConvertODTTF(fnTTF, fnODTTF, fnODTTF);
        util.ODTTF2TTF(fnODTTF);
        return fnODTTF;
    }

    public static String ODTTF2TTF(String fnODTTF) {
        String fnTTF = String.valueOf(fnODTTF) + ".TTF";
        util.ConvertODTTF(fnODTTF, fnTTF, fnODTTF);
        return fnTTF;
    }

    public static void Unzip(String inputZipFile, String outputDirectory) {
        System.out.println("\u5165\u529bZIP\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002" + inputZipFile);
        System.out.println("\u51fa\u529b\u5148\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002" + outputDirectory);
        io src = new io();
        io dst = new io();
        try {
            ZipInputStream zis = new ZipInputStream(src.GetInputStream(inputZipFile));
            ZipEntry entry = null;
            while ((entry = zis.getNextEntry()) != null) {
                String absoluteEntryPath = String.valueOf(outputDirectory) + entry.getName();
                System.out.println("\u51fa\u529b:" + absoluteEntryPath);
                File file = new File(absoluteEntryPath);
                if (entry.isDirectory()) {
                    file.mkdirs();
                } else {
                    int nRead;
                    file.mkdirs();
                    file.delete();
                    dst.Open(String.valueOf(outputDirectory) + entry.getName(), "w");
                    byte[] buffer = new byte[1024];
                    while ((nRead = zis.read(buffer)) > 0) {
                        dst.write(buffer, nRead);
                    }
                    dst.Close();
                }
                zis.closeEntry();
            }
            zis.close();
            src.Close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void Zip(String zipFileName, String inputFileName) throws IOException {
        System.out.println("Zip : " + inputFileName + " into " + zipFileName);
        File file = new File(inputFileName);
        deleteLength = file.getPath().length() - file.getName().length();
        io dst = new io();
        ZipOutputStream out = new ZipOutputStream(dst.GetOutputStream(zipFileName));
        util.createZip(out, file);
        out.close();
    }

    private static void createZip(ZipOutputStream out, File inputFile) throws IOException {
        System.out.println("createZip : " + inputFile.getName());
        if (inputFile.isDirectory()) {
            File[] files = inputFile.listFiles();
            int i = 0;
            while (i < files.length) {
                util.createZip(out, files[i]);
                ++i;
            }
        } else {
            int count;
            ZipEntry target = new ZipEntry(util.removePath(inputFile));
            out.putNextEntry(target);
            byte[] buf = new byte[1024];
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputFile));
            while ((count = in.read(buf, 0, 1024)) != -1) {
                out.write(buf, 0, count);
            }
            in.close();
            out.closeEntry();
        }
    }

    private static String removePath(File file) {
        return file.getPath().substring(deleteLength);
    }

    public static String GetPrivateProfileString(String fileIni, String sec, String key) {
        String str = "";
        try {
            Properties p = new Properties();
            p.load(new FileInputStream(new File(fileIni)));
            str = p.getProperty(key);
        }
        catch (Exception e) {
            str = "";
        }
        return str;
    }
}

