/*
 * Decompiled with CFR 0.152.
 */
package inaba.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;

public class io {
    private String openmode = "";
    private FileInputStream fis;
    private BufferedInputStream bis;
    private FileOutputStream fos;
    private RandomAccessFile raf;

    private int OpenInputStream(String filename) {
        int ret = 0;
        try {
            this.fis = new FileInputStream(filename);
            this.bis = new BufferedInputStream(this.fis);
        }
        catch (Exception e) {
            ret = -1;
        }
        return ret;
    }

    private int CloseInputStream() {
        try {
            this.bis.close();
            this.fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    private int OpenOutputStream(String filename) {
        try {
            this.fos = new FileOutputStream(filename);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    private int CloseOutputStream() {
        try {
            this.fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    private int OpenRandomAccess(String filename) {
        try {
            this.raf = new RandomAccessFile(filename, "rw");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    private int CloseRandomAccess() {
        try {
            this.raf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int Open(String filename, String mode) {
        int ret = 0;
        try {
            this.openmode = mode;
            if (mode == "r") {
                ret = this.OpenInputStream(filename);
            } else if (mode == "w") {
                ret = this.OpenOutputStream(filename);
            } else if (mode == "rw") {
                ret = this.OpenRandomAccess(filename);
            }
        }
        catch (Exception e) {
            ret = -1;
        }
        return ret;
    }

    public int Close() {
        int ret = 0;
        try {
            if (this.openmode == "r") {
                ret = this.CloseInputStream();
            } else if (this.openmode == "w") {
                ret = this.CloseOutputStream();
            } else if (this.openmode == "rw") {
                ret = this.CloseRandomAccess();
            }
        }
        catch (Exception e) {
            ret = -1;
        }
        this.openmode = "";
        return ret;
    }

    public int read(byte[] moji, int length) {
        int ret = -1;
        try {
            if (length <= 0 || moji.length < length) {
                length = moji.length;
            }
            if (this.openmode == "r") {
                ret = this.bis.read(moji, 0, length);
            } else if (this.openmode == "rw") {
                ret = this.raf.read(moji, 0, length);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public int write(byte[] moji, int length) {
        int ret = 0;
        try {
            if (length < 0) {
                length = moji.length;
            }
            if (length > 0) {
                if (this.openmode == "w") {
                    this.fos.write(moji, 0, length);
                } else if (this.openmode == "rw") {
                    this.raf.write(moji, 0, length);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public int seek(int pos) {
        int ret = -1;
        try {
            if (this.openmode == "rw") {
                if (pos >= 0) {
                    this.raf.seek(pos);
                }
                ret = (int)this.raf.getFilePointer();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public FileInputStream GetInputStream(String filename) {
        try {
            this.fis = new FileInputStream(filename);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.fis;
    }

    public FileOutputStream GetOutputStream(String filename) {
        try {
            this.fos = new FileOutputStream(filename);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.fos;
    }

    public static int Delete(String filename) {
        int ret = -1;
        try {
            File file = new File(filename);
            if (file.delete()) {
                ret = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static int Rename(String fnOld, String fnNew) {
        int ret = -1;
        try {
            File fileOld = new File(fnOld);
            File fileNew = new File(fnNew);
            if (fileOld.renameTo(fileNew)) {
                ret = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static int MakeDir(String strPath) {
        int ret = -1;
        try {
            File f = new File(strPath);
            if (f.mkdirs()) {
                ret = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

