/*
 * Decompiled with CFR 0.152.
 */
import inaba.file.io;
import inaba.file.util;
import java.applet.Applet;
import java.awt.Button;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class WARemix
extends Applet
implements ActionListener {
    private String fnWave = "";
    String fnRemix = "";
    int cmd = 0;
    int btnWidth = 100;

    public void actionPerformed(ActionEvent e) {
        FileDialog fd = new FileDialog(new Frame("Select Wave"), "WA Remix", 0);
        fd.setVisible(true);
        if (fd.getFile() != null) {
            this.fnWave = String.valueOf(fd.getDirectory()) + fd.getFile();
            if (e.getActionCommand().equals("remix")) {
                this.cmd = 1;
            }
            if (e.getActionCommand().equals("mirror")) {
                this.cmd = 2;
            }
            if (e.getActionCommand().equals("reverse")) {
                this.cmd = 3;
            }
        }
    }

    public void init() {
        this.setLayout(null);
        Button btn1 = (Button)this.add(new Button("Fake-Remix"));
        btn1.addActionListener(this);
        btn1.setActionCommand("remix");
        btn1.setBounds(0, 0, this.btnWidth, 30);
        Button btn2 = (Button)this.add(new Button("\u5de6\u53f3\u53cd\u8ee2"));
        btn2.addActionListener(this);
        btn2.setActionCommand("mirror");
        btn2.setBounds(btn1.getX(), btn1.getY() + btn1.getHeight(), btn1.getWidth(), btn1.getHeight());
        Button btn3 = (Button)this.add(new Button("\u9006\u56de\u8ee2"));
        btn3.addActionListener(this);
        btn3.setActionCommand("reverse");
        btn3.setBounds(btn1.getX(), btn2.getY() + btn2.getHeight(), btn1.getWidth(), btn1.getHeight());
    }

    public void remix() {
        if (this.fnWave != "" && this.cmd > 0) {
            switch (this.cmd) {
                case 1: {
                    this.fnRemix = String.valueOf(this.fnWave) + ".remix.wav";
                    break;
                }
                case 2: {
                    this.fnRemix = String.valueOf(this.fnWave) + ".mirror.wav";
                    break;
                }
                case 3: {
                    this.fnRemix = String.valueOf(this.fnWave) + ".reverse.wav";
                }
            }
            io src = new io();
            io dst = new io();
            try {
                src.Open(this.fnWave, "r");
                dst.Open(this.fnRemix, "rw");
                byte[] tag = new byte[4];
                byte[] buffer = new byte[1024];
                int pos = 0;
                int nRead = src.read(buffer, 12);
                int val = util.GetIntFromBytes(buffer, 4, 4);
                dst.write(buffer, nRead);
                pos += nRead;
                System.out.printf("RIFF size=%x\n", val);
                while (true) {
                    nRead = src.read(tag, 4);
                    nRead = src.read(buffer, 4);
                    val = util.GetIntFromBytes(buffer, 0, 4);
                    dst.write(tag, 4);
                    dst.write(buffer, nRead);
                    pos += 4 + nRead;
                    if (new String(tag).equals("data")) {
                        System.out.printf("data size=%x\n", val);
                        pos += val - 4;
                        while (val > 0) {
                            nRead = src.read(buffer, 4);
                            short left = (short)util.GetIntFromBytes(buffer, 0, 2);
                            short right = (short)util.GetIntFromBytes(buffer, 2, 2);
                            switch (this.cmd) {
                                case 1: {
                                    left = (short)((left - right) / 2);
                                    break;
                                }
                                case 2: {
                                    short tmp = left;
                                    left = right;
                                    right = tmp;
                                    break;
                                }
                                case 3: {
                                    dst.seek(pos);
                                    pos -= 4;
                                }
                            }
                            util.SetIntToBytes(buffer, 0, 2, left);
                            util.SetIntToBytes(buffer, 2, 2, right);
                            dst.write(buffer, 4);
                            val -= 4;
                        }
                        break;
                    }
                    System.out.printf("%c%c%c%c size=%x\n", tag[0], tag[1], tag[2], tag[3], val);
                    if (buffer.length < val) {
                        System.out.printf("\u30d0\u30c3\u30d5\u30a1\u304c\u8db3\u308a\u307e\u305b\u3093\n", new Object[0]);
                        break;
                    }
                    nRead = src.read(buffer, val);
                    dst.write(buffer, nRead);
                    pos += nRead;
                }
            }
            finally {
                src.Close();
                dst.Close();
            }
            System.out.println("Create : " + this.fnRemix);
            this.fnWave = "";
            this.cmd = 0;
        }
    }

    public void paint(Graphics g) {
        if (this.fnWave != "") {
            g.drawString(this.fnWave, this.btnWidth + 10, 30);
            g.drawString("Creating...", this.btnWidth + 10, 45);
            this.remix();
            g.drawString("Created : " + this.fnRemix, this.btnWidth + 10, 60);
        }
    }

    public static void main(String[] args) {
        WARemix applet = new WARemix();
        applet.init();
        Frame f = new Frame();
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        f.add(applet);
        f.setSize(640, 200);
        f.show();
    }
}

